# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 5
# Experiment: PMxPM, Run: 2
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A_MR5_strategy.txt
# LLM Suggested Fallback: D

def velvet_shadow(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    total_rounds = 10
    
    if current_round == 1:
        return "C"
    
    if current_round <= 3:
        return opp_history[-1]
    
    if current_round <= 7:
        if len(opp_history) >= 2 and all(m == "C" for m in opp_history[-2:]):
            return "D"
        else:
            return opp_history[-1]
    
    if current_round >= 8:
        if "random.random() < 0.6" in opponent_program_code or "forgiveness" in opponent_program_code.lower():
            return "D"
        elif len(opp_history) >= 2 and opp_history[-1] == "C" and opp_history[-2] == "C":
            return "D"
        else:
            return opp_history[-1]
    
    return "D"